/* automatically generated by rust-bindgen 0.70.1 */

#[repr(C)]
#[derive(Copy, Clone, Debug, Default, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct __BindgenBitfieldUnit<Storage> {
    storage: Storage,
}
impl<Storage> __BindgenBitfieldUnit<Storage> {
    #[inline]
    pub const fn new(storage: Storage) -> Self {
        Self { storage }
    }
}
impl<Storage> __BindgenBitfieldUnit<Storage>
where
    Storage: AsRef<[u8]> + AsMut<[u8]>,
{
    #[inline]
    pub fn get_bit(&self, index: usize) -> bool {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = self.storage.as_ref()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        byte & mask == mask
    }
    #[inline]
    pub fn set_bit(&mut self, index: usize, val: bool) {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = &mut self.storage.as_mut()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        if val {
            *byte |= mask;
        } else {
            *byte &= !mask;
        }
    }
    #[inline]
    pub fn get(&self, bit_offset: usize, bit_width: u8) -> u64 {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        let mut val = 0;
        for i in 0..(bit_width as usize) {
            if self.get_bit(i + bit_offset) {
                let index = if cfg!(target_endian = "big") {
                    bit_width as usize - 1 - i
                } else {
                    i
                };
                val |= 1 << index;
            }
        }
        val
    }
    #[inline]
    pub fn set(&mut self, bit_offset: usize, bit_width: u8, val: u64) {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            let index = if cfg!(target_endian = "big") {
                bit_width as usize - 1 - i
            } else {
                i
            };
            self.set_bit(index + bit_offset, val_bit_is_set);
        }
    }
}
#[repr(C)]
#[derive(Default)]
pub struct __IncompleteArrayField<T>(::std::marker::PhantomData<T>, [T; 0]);
impl<T> __IncompleteArrayField<T> {
    #[inline]
    pub const fn new() -> Self {
        __IncompleteArrayField(::std::marker::PhantomData, [])
    }
    #[inline]
    pub fn as_ptr(&self) -> *const T {
        self as *const _ as *const T
    }
    #[inline]
    pub fn as_mut_ptr(&mut self) -> *mut T {
        self as *mut _ as *mut T
    }
    #[inline]
    pub unsafe fn as_slice(&self, len: usize) -> &[T] {
        ::std::slice::from_raw_parts(self.as_ptr(), len)
    }
    #[inline]
    pub unsafe fn as_mut_slice(&mut self, len: usize) -> &mut [T] {
        ::std::slice::from_raw_parts_mut(self.as_mut_ptr(), len)
    }
}
impl<T> ::std::fmt::Debug for __IncompleteArrayField<T> {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.write_str("__IncompleteArrayField")
    }
}
#[repr(C)]
pub struct __BindgenUnionField<T>(::std::marker::PhantomData<T>);
impl<T> __BindgenUnionField<T> {
    #[inline]
    pub const fn new() -> Self {
        __BindgenUnionField(::std::marker::PhantomData)
    }
    #[inline]
    pub unsafe fn as_ref(&self) -> &T {
        ::std::mem::transmute(self)
    }
    #[inline]
    pub unsafe fn as_mut(&mut self) -> &mut T {
        ::std::mem::transmute(self)
    }
}
impl<T> ::std::default::Default for __BindgenUnionField<T> {
    #[inline]
    fn default() -> Self {
        Self::new()
    }
}
impl<T> ::std::clone::Clone for __BindgenUnionField<T> {
    #[inline]
    fn clone(&self) -> Self {
        *self
    }
}
impl<T> ::std::marker::Copy for __BindgenUnionField<T> {}
impl<T> ::std::fmt::Debug for __BindgenUnionField<T> {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.write_str("__BindgenUnionField")
    }
}
impl<T> ::std::hash::Hash for __BindgenUnionField<T> {
    fn hash<H: ::std::hash::Hasher>(&self, _state: &mut H) {}
}
impl<T> ::std::cmp::PartialEq for __BindgenUnionField<T> {
    fn eq(&self, _other: &__BindgenUnionField<T>) -> bool {
        true
    }
}
impl<T> ::std::cmp::Eq for __BindgenUnionField<T> {}
pub const INTEGER_REDEFINED_OP_FLAG: u32 = 1;
pub const FLOAT_REDEFINED_OP_FLAG: u32 = 2;
pub const STRING_REDEFINED_OP_FLAG: u32 = 4;
pub const ARRAY_REDEFINED_OP_FLAG: u32 = 8;
pub const HASH_REDEFINED_OP_FLAG: u32 = 16;
pub const SYMBOL_REDEFINED_OP_FLAG: u32 = 64;
pub const TIME_REDEFINED_OP_FLAG: u32 = 128;
pub const REGEXP_REDEFINED_OP_FLAG: u32 = 256;
pub const NIL_REDEFINED_OP_FLAG: u32 = 512;
pub const TRUE_REDEFINED_OP_FLAG: u32 = 1024;
pub const FALSE_REDEFINED_OP_FLAG: u32 = 2048;
pub const PROC_REDEFINED_OP_FLAG: u32 = 4096;
pub const VM_KW_SPECIFIED_BITS_MAX: u32 = 31;
pub const VM_ENV_DATA_SIZE: u32 = 3;
pub const VM_ENV_DATA_INDEX_ME_CREF: i32 = -2;
pub const VM_ENV_DATA_INDEX_SPECVAL: i32 = -1;
pub const VM_ENV_DATA_INDEX_FLAGS: u32 = 0;
pub const VM_BLOCK_HANDLER_NONE: u32 = 0;
pub const SHAPE_ID_NUM_BITS: u32 = 32;
pub type ID = ::std::os::raw::c_ulong;
pub type rb_alloc_func_t = ::std::option::Option<unsafe extern "C" fn(klass: VALUE) -> VALUE>;
pub const RUBY_Qfalse: ruby_special_consts = 0;
pub const RUBY_Qnil: ruby_special_consts = 4;
pub const RUBY_Qtrue: ruby_special_consts = 20;
pub const RUBY_Qundef: ruby_special_consts = 36;
pub const RUBY_IMMEDIATE_MASK: ruby_special_consts = 7;
pub const RUBY_FIXNUM_FLAG: ruby_special_consts = 1;
pub const RUBY_FLONUM_MASK: ruby_special_consts = 3;
pub const RUBY_FLONUM_FLAG: ruby_special_consts = 2;
pub const RUBY_SYMBOL_FLAG: ruby_special_consts = 12;
pub const RUBY_SPECIAL_SHIFT: ruby_special_consts = 8;
pub type ruby_special_consts = u32;
#[repr(C)]
pub struct RBasic {
    pub flags: VALUE,
    pub klass: VALUE,
}
pub const RUBY_T_NONE: ruby_value_type = 0;
pub const RUBY_T_OBJECT: ruby_value_type = 1;
pub const RUBY_T_CLASS: ruby_value_type = 2;
pub const RUBY_T_MODULE: ruby_value_type = 3;
pub const RUBY_T_FLOAT: ruby_value_type = 4;
pub const RUBY_T_STRING: ruby_value_type = 5;
pub const RUBY_T_REGEXP: ruby_value_type = 6;
pub const RUBY_T_ARRAY: ruby_value_type = 7;
pub const RUBY_T_HASH: ruby_value_type = 8;
pub const RUBY_T_STRUCT: ruby_value_type = 9;
pub const RUBY_T_BIGNUM: ruby_value_type = 10;
pub const RUBY_T_FILE: ruby_value_type = 11;
pub const RUBY_T_DATA: ruby_value_type = 12;
pub const RUBY_T_MATCH: ruby_value_type = 13;
pub const RUBY_T_COMPLEX: ruby_value_type = 14;
pub const RUBY_T_RATIONAL: ruby_value_type = 15;
pub const RUBY_T_NIL: ruby_value_type = 17;
pub const RUBY_T_TRUE: ruby_value_type = 18;
pub const RUBY_T_FALSE: ruby_value_type = 19;
pub const RUBY_T_SYMBOL: ruby_value_type = 20;
pub const RUBY_T_FIXNUM: ruby_value_type = 21;
pub const RUBY_T_UNDEF: ruby_value_type = 22;
pub const RUBY_T_IMEMO: ruby_value_type = 26;
pub const RUBY_T_NODE: ruby_value_type = 27;
pub const RUBY_T_ICLASS: ruby_value_type = 28;
pub const RUBY_T_ZOMBIE: ruby_value_type = 29;
pub const RUBY_T_MOVED: ruby_value_type = 30;
pub const RUBY_T_MASK: ruby_value_type = 31;
pub type ruby_value_type = u32;
pub const RUBY_FL_USHIFT: ruby_fl_ushift = 12;
pub type ruby_fl_ushift = u32;
pub const RUBY_FL_WB_PROTECTED: ruby_fl_type = 32;
pub const RUBY_FL_PROMOTED: ruby_fl_type = 32;
pub const RUBY_FL_USERPRIV0: ruby_fl_type = 64;
pub const RUBY_FL_FINALIZE: ruby_fl_type = 128;
pub const RUBY_FL_TAINT: ruby_fl_type = 0;
pub const RUBY_FL_EXIVAR: ruby_fl_type = 0;
pub const RUBY_FL_SHAREABLE: ruby_fl_type = 256;
pub const RUBY_FL_UNTRUSTED: ruby_fl_type = 0;
pub const RUBY_FL_UNUSED9: ruby_fl_type = 512;
pub const RUBY_FL_UNUSED10: ruby_fl_type = 1024;
pub const RUBY_FL_FREEZE: ruby_fl_type = 2048;
pub const RUBY_FL_USER0: ruby_fl_type = 4096;
pub const RUBY_FL_USER1: ruby_fl_type = 8192;
pub const RUBY_FL_USER2: ruby_fl_type = 16384;
pub const RUBY_FL_USER3: ruby_fl_type = 32768;
pub const RUBY_FL_USER4: ruby_fl_type = 65536;
pub const RUBY_FL_USER5: ruby_fl_type = 131072;
pub const RUBY_FL_USER6: ruby_fl_type = 262144;
pub const RUBY_FL_USER7: ruby_fl_type = 524288;
pub const RUBY_FL_USER8: ruby_fl_type = 1048576;
pub const RUBY_FL_USER9: ruby_fl_type = 2097152;
pub const RUBY_FL_USER10: ruby_fl_type = 4194304;
pub const RUBY_FL_USER11: ruby_fl_type = 8388608;
pub const RUBY_FL_USER12: ruby_fl_type = 16777216;
pub const RUBY_FL_USER13: ruby_fl_type = 33554432;
pub const RUBY_FL_USER14: ruby_fl_type = 67108864;
pub const RUBY_FL_USER15: ruby_fl_type = 134217728;
pub const RUBY_FL_USER16: ruby_fl_type = 268435456;
pub const RUBY_FL_USER17: ruby_fl_type = 536870912;
pub const RUBY_FL_USER18: ruby_fl_type = 1073741824;
pub const RUBY_FL_USER19: ruby_fl_type = -2147483648;
pub const RUBY_ELTS_SHARED: ruby_fl_type = 4096;
pub const RUBY_FL_SINGLETON: ruby_fl_type = 8192;
pub type ruby_fl_type = i32;
pub const RSTRING_NOEMBED: ruby_rstring_flags = 8192;
pub const RSTRING_FSTR: ruby_rstring_flags = 536870912;
pub type ruby_rstring_flags = u32;
pub type st_data_t = ::std::os::raw::c_ulong;
pub type st_index_t = st_data_t;
pub const ST_CONTINUE: st_retval = 0;
pub const ST_STOP: st_retval = 1;
pub const ST_DELETE: st_retval = 2;
pub const ST_CHECK: st_retval = 3;
pub const ST_REPLACE: st_retval = 4;
pub type st_retval = u32;
pub type st_foreach_callback_func = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: st_data_t,
        arg2: st_data_t,
        arg3: st_data_t,
    ) -> ::std::os::raw::c_int,
>;
pub const RARRAY_EMBED_FLAG: ruby_rarray_flags = 8192;
pub const RARRAY_EMBED_LEN_MASK: ruby_rarray_flags = 4161536;
pub type ruby_rarray_flags = u32;
pub const RARRAY_EMBED_LEN_SHIFT: ruby_rarray_consts = 15;
pub type ruby_rarray_consts = u32;
pub const RMODULE_IS_REFINEMENT: ruby_rmodule_flags = 8192;
pub type ruby_rmodule_flags = u32;
pub const ROBJECT_HEAP: ruby_robject_flags = 65536;
pub type ruby_robject_flags = u32;
pub type rb_block_call_func = ::std::option::Option<
    unsafe extern "C" fn(
        yielded_arg: VALUE,
        callback_arg: VALUE,
        argc: ::std::os::raw::c_int,
        argv: *const VALUE,
        blockarg: VALUE,
    ) -> VALUE,
>;
pub type rb_block_call_func_t = rb_block_call_func;
pub const RUBY_ENCODING_INLINE_MAX: ruby_encoding_consts = 127;
pub const RUBY_ENCODING_SHIFT: ruby_encoding_consts = 22;
pub const RUBY_ENCODING_MASK: ruby_encoding_consts = 532676608;
pub const RUBY_ENCODING_MAXNAMELEN: ruby_encoding_consts = 42;
pub type ruby_encoding_consts = u32;
pub const RUBY_ENCINDEX_ASCII_8BIT: ruby_preserved_encindex = 0;
pub const RUBY_ENCINDEX_UTF_8: ruby_preserved_encindex = 1;
pub const RUBY_ENCINDEX_US_ASCII: ruby_preserved_encindex = 2;
pub const RUBY_ENCINDEX_UTF_16BE: ruby_preserved_encindex = 3;
pub const RUBY_ENCINDEX_UTF_16LE: ruby_preserved_encindex = 4;
pub const RUBY_ENCINDEX_UTF_32BE: ruby_preserved_encindex = 5;
pub const RUBY_ENCINDEX_UTF_32LE: ruby_preserved_encindex = 6;
pub const RUBY_ENCINDEX_UTF_16: ruby_preserved_encindex = 7;
pub const RUBY_ENCINDEX_UTF_32: ruby_preserved_encindex = 8;
pub const RUBY_ENCINDEX_UTF8_MAC: ruby_preserved_encindex = 9;
pub const RUBY_ENCINDEX_EUC_JP: ruby_preserved_encindex = 10;
pub const RUBY_ENCINDEX_Windows_31J: ruby_preserved_encindex = 11;
pub const RUBY_ENCINDEX_BUILTIN_MAX: ruby_preserved_encindex = 12;
pub type ruby_preserved_encindex = u32;
pub const BOP_PLUS: ruby_basic_operators = 0;
pub const BOP_MINUS: ruby_basic_operators = 1;
pub const BOP_MULT: ruby_basic_operators = 2;
pub const BOP_DIV: ruby_basic_operators = 3;
pub const BOP_MOD: ruby_basic_operators = 4;
pub const BOP_EQ: ruby_basic_operators = 5;
pub const BOP_EQQ: ruby_basic_operators = 6;
pub const BOP_LT: ruby_basic_operators = 7;
pub const BOP_LE: ruby_basic_operators = 8;
pub const BOP_LTLT: ruby_basic_operators = 9;
pub const BOP_AREF: ruby_basic_operators = 10;
pub const BOP_ASET: ruby_basic_operators = 11;
pub const BOP_LENGTH: ruby_basic_operators = 12;
pub const BOP_SIZE: ruby_basic_operators = 13;
pub const BOP_EMPTY_P: ruby_basic_operators = 14;
pub const BOP_NIL_P: ruby_basic_operators = 15;
pub const BOP_SUCC: ruby_basic_operators = 16;
pub const BOP_GT: ruby_basic_operators = 17;
pub const BOP_GE: ruby_basic_operators = 18;
pub const BOP_GTGT: ruby_basic_operators = 19;
pub const BOP_NOT: ruby_basic_operators = 20;
pub const BOP_NEQ: ruby_basic_operators = 21;
pub const BOP_MATCH: ruby_basic_operators = 22;
pub const BOP_FREEZE: ruby_basic_operators = 23;
pub const BOP_UMINUS: ruby_basic_operators = 24;
pub const BOP_MAX: ruby_basic_operators = 25;
pub const BOP_MIN: ruby_basic_operators = 26;
pub const BOP_HASH: ruby_basic_operators = 27;
pub const BOP_CALL: ruby_basic_operators = 28;
pub const BOP_AND: ruby_basic_operators = 29;
pub const BOP_OR: ruby_basic_operators = 30;
pub const BOP_CMP: ruby_basic_operators = 31;
pub const BOP_DEFAULT: ruby_basic_operators = 32;
pub const BOP_PACK: ruby_basic_operators = 33;
pub const BOP_INCLUDE_P: ruby_basic_operators = 34;
pub const BOP_LAST_: ruby_basic_operators = 35;
pub type ruby_basic_operators = u32;
pub type rb_serial_t = ::std::os::raw::c_ulonglong;
pub const imemo_env: imemo_type = 0;
pub const imemo_cref: imemo_type = 1;
pub const imemo_svar: imemo_type = 2;
pub const imemo_throw_data: imemo_type = 3;
pub const imemo_ifunc: imemo_type = 4;
pub const imemo_memo: imemo_type = 5;
pub const imemo_ment: imemo_type = 6;
pub const imemo_iseq: imemo_type = 7;
pub const imemo_tmpbuf: imemo_type = 8;
pub const imemo_callinfo: imemo_type = 10;
pub const imemo_callcache: imemo_type = 11;
pub const imemo_constcache: imemo_type = 12;
pub const imemo_fields: imemo_type = 13;
pub type imemo_type = u32;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct vm_ifunc_argc {
    pub min: ::std::os::raw::c_int,
    pub max: ::std::os::raw::c_int,
}
#[repr(C)]
pub struct vm_ifunc {
    pub flags: VALUE,
    pub svar_lep: *mut VALUE,
    pub func: rb_block_call_func_t,
    pub data: *const ::std::os::raw::c_void,
    pub argc: vm_ifunc_argc,
}
pub const METHOD_VISI_UNDEF: rb_method_visibility_t = 0;
pub const METHOD_VISI_PUBLIC: rb_method_visibility_t = 1;
pub const METHOD_VISI_PRIVATE: rb_method_visibility_t = 2;
pub const METHOD_VISI_PROTECTED: rb_method_visibility_t = 3;
pub const METHOD_VISI_MASK: rb_method_visibility_t = 3;
pub type rb_method_visibility_t = u32;
#[repr(C)]
pub struct rb_method_entry_struct {
    pub flags: VALUE,
    pub defined_class: VALUE,
    pub def: *mut rb_method_definition_struct,
    pub called_id: ID,
    pub owner: VALUE,
}
pub type rb_method_entry_t = rb_method_entry_struct;
#[repr(C)]
pub struct rb_callable_method_entry_struct {
    pub flags: VALUE,
    pub defined_class: VALUE,
    pub def: *mut rb_method_definition_struct,
    pub called_id: ID,
    pub owner: VALUE,
}
pub type rb_callable_method_entry_t = rb_callable_method_entry_struct;
pub const VM_METHOD_TYPE_ISEQ: rb_method_type_t = 0;
pub const VM_METHOD_TYPE_CFUNC: rb_method_type_t = 1;
pub const VM_METHOD_TYPE_ATTRSET: rb_method_type_t = 2;
pub const VM_METHOD_TYPE_IVAR: rb_method_type_t = 3;
pub const VM_METHOD_TYPE_BMETHOD: rb_method_type_t = 4;
pub const VM_METHOD_TYPE_ZSUPER: rb_method_type_t = 5;
pub const VM_METHOD_TYPE_ALIAS: rb_method_type_t = 6;
pub const VM_METHOD_TYPE_UNDEF: rb_method_type_t = 7;
pub const VM_METHOD_TYPE_NOTIMPLEMENTED: rb_method_type_t = 8;
pub const VM_METHOD_TYPE_OPTIMIZED: rb_method_type_t = 9;
pub const VM_METHOD_TYPE_MISSING: rb_method_type_t = 10;
pub const VM_METHOD_TYPE_REFINED: rb_method_type_t = 11;
pub type rb_method_type_t = u32;
pub type rb_cfunc_t = ::std::option::Option<unsafe extern "C" fn() -> VALUE>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rb_method_cfunc_struct {
    pub func: rb_cfunc_t,
    pub invoker: ::std::option::Option<
        unsafe extern "C" fn(
            recv: VALUE,
            argc: ::std::os::raw::c_int,
            argv: *const VALUE,
            func: ::std::option::Option<unsafe extern "C" fn() -> VALUE>,
        ) -> VALUE,
    >,
    pub argc: ::std::os::raw::c_int,
}
pub const OPTIMIZED_METHOD_TYPE_SEND: method_optimized_type = 0;
pub const OPTIMIZED_METHOD_TYPE_CALL: method_optimized_type = 1;
pub const OPTIMIZED_METHOD_TYPE_BLOCK_CALL: method_optimized_type = 2;
pub const OPTIMIZED_METHOD_TYPE_STRUCT_AREF: method_optimized_type = 3;
pub const OPTIMIZED_METHOD_TYPE_STRUCT_ASET: method_optimized_type = 4;
pub const OPTIMIZED_METHOD_TYPE__MAX: method_optimized_type = 5;
pub type method_optimized_type = u32;
pub type rb_num_t = ::std::os::raw::c_ulong;
pub const RUBY_TAG_NONE: ruby_tag_type = 0;
pub const RUBY_TAG_RETURN: ruby_tag_type = 1;
pub const RUBY_TAG_BREAK: ruby_tag_type = 2;
pub const RUBY_TAG_NEXT: ruby_tag_type = 3;
pub const RUBY_TAG_RETRY: ruby_tag_type = 4;
pub const RUBY_TAG_REDO: ruby_tag_type = 5;
pub const RUBY_TAG_RAISE: ruby_tag_type = 6;
pub const RUBY_TAG_THROW: ruby_tag_type = 7;
pub const RUBY_TAG_FATAL: ruby_tag_type = 8;
pub const RUBY_TAG_MASK: ruby_tag_type = 15;
pub type ruby_tag_type = u32;
pub const VM_THROW_NO_ESCAPE_FLAG: ruby_vm_throw_flags = 32768;
pub const VM_THROW_STATE_MASK: ruby_vm_throw_flags = 255;
pub type ruby_vm_throw_flags = u32;
#[repr(C)]
pub struct iseq_inline_constant_cache_entry {
    pub flags: VALUE,
    pub value: VALUE,
    pub ic_cref: *const rb_cref_t,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct iseq_inline_constant_cache {
    pub entry: *mut iseq_inline_constant_cache_entry,
    pub segments: *const ID,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct iseq_inline_iv_cache_entry {
    pub value: u64,
    pub iv_set_name: ID,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct iseq_inline_cvar_cache_entry {
    pub entry: *mut rb_cvar_class_tbl_entry,
}
pub const ISEQ_TYPE_TOP: rb_iseq_type = 0;
pub const ISEQ_TYPE_METHOD: rb_iseq_type = 1;
pub const ISEQ_TYPE_BLOCK: rb_iseq_type = 2;
pub const ISEQ_TYPE_CLASS: rb_iseq_type = 3;
pub const ISEQ_TYPE_RESCUE: rb_iseq_type = 4;
pub const ISEQ_TYPE_ENSURE: rb_iseq_type = 5;
pub const ISEQ_TYPE_EVAL: rb_iseq_type = 6;
pub const ISEQ_TYPE_MAIN: rb_iseq_type = 7;
pub const ISEQ_TYPE_PLAIN: rb_iseq_type = 8;
pub type rb_iseq_type = u32;
pub const BUILTIN_ATTR_LEAF: rb_builtin_attr = 1;
pub const BUILTIN_ATTR_SINGLE_NOARG_LEAF: rb_builtin_attr = 2;
pub const BUILTIN_ATTR_INLINE_BLOCK: rb_builtin_attr = 4;
pub const BUILTIN_ATTR_C_TRACE: rb_builtin_attr = 8;
pub type rb_builtin_attr = u32;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rb_iseq_constant_body_rb_iseq_parameters_rb_iseq_param_keyword {
    pub num: ::std::os::raw::c_int,
    pub required_num: ::std::os::raw::c_int,
    pub bits_start: ::std::os::raw::c_int,
    pub rest_start: ::std::os::raw::c_int,
    pub table: *const ID,
    pub default_values: *mut VALUE,
}
#[repr(C)]
pub struct rb_captured_block {
    pub self_: VALUE,
    pub ep: *const VALUE,
    pub code: rb_captured_block__bindgen_ty_1,
}
#[repr(C)]
pub struct rb_captured_block__bindgen_ty_1 {
    pub iseq: __BindgenUnionField<*const rb_iseq_t>,
    pub ifunc: __BindgenUnionField<*const vm_ifunc>,
    pub val: __BindgenUnionField<VALUE>,
    pub bindgen_union_field: u64,
}
pub const block_type_iseq: rb_block_type = 0;
pub const block_type_ifunc: rb_block_type = 1;
pub const block_type_symbol: rb_block_type = 2;
pub const block_type_proc: rb_block_type = 3;
pub type rb_block_type = u32;
#[repr(C)]
pub struct rb_block {
    pub as_: rb_block__bindgen_ty_1,
    pub type_: rb_block_type,
}
#[repr(C)]
pub struct rb_block__bindgen_ty_1 {
    pub captured: __BindgenUnionField<rb_captured_block>,
    pub symbol: __BindgenUnionField<VALUE>,
    pub proc_: __BindgenUnionField<VALUE>,
    pub bindgen_union_field: [u64; 3usize],
}
pub type rb_control_frame_t = rb_control_frame_struct;
#[repr(C)]
pub struct rb_proc_t {
    pub block: rb_block,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub __bindgen_padding_0: [u8; 7usize],
}
impl rb_proc_t {
    #[inline]
    pub fn is_from_method(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_from_method(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn is_lambda(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_lambda(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn is_isolated(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_isolated(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        is_from_method: ::std::os::raw::c_uint,
        is_lambda: ::std::os::raw::c_uint,
        is_isolated: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let is_from_method: u32 = unsafe { ::std::mem::transmute(is_from_method) };
            is_from_method as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let is_lambda: u32 = unsafe { ::std::mem::transmute(is_lambda) };
            is_lambda as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let is_isolated: u32 = unsafe { ::std::mem::transmute(is_isolated) };
            is_isolated as u64
        });
        __bindgen_bitfield_unit
    }
}
pub const VM_CHECKMATCH_TYPE_WHEN: vm_check_match_type = 1;
pub const VM_CHECKMATCH_TYPE_CASE: vm_check_match_type = 2;
pub const VM_CHECKMATCH_TYPE_RESCUE: vm_check_match_type = 3;
pub type vm_check_match_type = u32;
pub const VM_OPT_NEWARRAY_SEND_MAX: vm_opt_newarray_send_type = 1;
pub const VM_OPT_NEWARRAY_SEND_MIN: vm_opt_newarray_send_type = 2;
pub const VM_OPT_NEWARRAY_SEND_HASH: vm_opt_newarray_send_type = 3;
pub const VM_OPT_NEWARRAY_SEND_PACK: vm_opt_newarray_send_type = 4;
pub const VM_OPT_NEWARRAY_SEND_PACK_BUFFER: vm_opt_newarray_send_type = 5;
pub const VM_OPT_NEWARRAY_SEND_INCLUDE_P: vm_opt_newarray_send_type = 6;
pub type vm_opt_newarray_send_type = u32;
pub const VM_SPECIAL_OBJECT_VMCORE: vm_special_object_type = 1;
pub const VM_SPECIAL_OBJECT_CBASE: vm_special_object_type = 2;
pub const VM_SPECIAL_OBJECT_CONST_BASE: vm_special_object_type = 3;
pub type vm_special_object_type = u32;
pub type IC = *mut iseq_inline_constant_cache;
pub type IVC = *mut iseq_inline_iv_cache_entry;
pub type ICVARC = *mut iseq_inline_cvar_cache_entry;
pub const VM_FRAME_MAGIC_METHOD: vm_frame_env_flags = 286326785;
pub const VM_FRAME_MAGIC_BLOCK: vm_frame_env_flags = 572653569;
pub const VM_FRAME_MAGIC_CLASS: vm_frame_env_flags = 858980353;
pub const VM_FRAME_MAGIC_TOP: vm_frame_env_flags = 1145307137;
pub const VM_FRAME_MAGIC_CFUNC: vm_frame_env_flags = 1431633921;
pub const VM_FRAME_MAGIC_IFUNC: vm_frame_env_flags = 1717960705;
pub const VM_FRAME_MAGIC_EVAL: vm_frame_env_flags = 2004287489;
pub const VM_FRAME_MAGIC_RESCUE: vm_frame_env_flags = 2022178817;
pub const VM_FRAME_MAGIC_DUMMY: vm_frame_env_flags = 2040070145;
pub const VM_FRAME_MAGIC_MASK: vm_frame_env_flags = 2147418113;
pub const VM_FRAME_FLAG_FINISH: vm_frame_env_flags = 32;
pub const VM_FRAME_FLAG_BMETHOD: vm_frame_env_flags = 64;
pub const VM_FRAME_FLAG_CFRAME: vm_frame_env_flags = 128;
pub const VM_FRAME_FLAG_LAMBDA: vm_frame_env_flags = 256;
pub const VM_FRAME_FLAG_MODIFIED_BLOCK_PARAM: vm_frame_env_flags = 512;
pub const VM_FRAME_FLAG_CFRAME_KW: vm_frame_env_flags = 1024;
pub const VM_FRAME_FLAG_PASSED: vm_frame_env_flags = 2048;
pub const VM_FRAME_FLAG_BOX_REQUIRE: vm_frame_env_flags = 4096;
pub const VM_ENV_FLAG_LOCAL: vm_frame_env_flags = 2;
pub const VM_ENV_FLAG_ESCAPED: vm_frame_env_flags = 4;
pub const VM_ENV_FLAG_WB_REQUIRED: vm_frame_env_flags = 8;
pub const VM_ENV_FLAG_ISOLATED: vm_frame_env_flags = 16;
pub type vm_frame_env_flags = u32;
pub type attr_index_t = u16;
pub type shape_id_t = u32;
pub const SHAPE_ID_HAS_IVAR_MASK: shape_id_mask = 134742014;
pub type shape_id_mask = u32;
#[repr(C)]
pub struct rb_cvar_class_tbl_entry {
    pub index: u32,
    pub global_cvar_state: rb_serial_t,
    pub cref: *const rb_cref_t,
    pub class_value: VALUE,
}
pub const VM_CALL_ARGS_SPLAT_bit: vm_call_flag_bits = 0;
pub const VM_CALL_ARGS_BLOCKARG_bit: vm_call_flag_bits = 1;
pub const VM_CALL_FCALL_bit: vm_call_flag_bits = 2;
pub const VM_CALL_VCALL_bit: vm_call_flag_bits = 3;
pub const VM_CALL_ARGS_SIMPLE_bit: vm_call_flag_bits = 4;
pub const VM_CALL_KWARG_bit: vm_call_flag_bits = 5;
pub const VM_CALL_KW_SPLAT_bit: vm_call_flag_bits = 6;
pub const VM_CALL_TAILCALL_bit: vm_call_flag_bits = 7;
pub const VM_CALL_SUPER_bit: vm_call_flag_bits = 8;
pub const VM_CALL_ZSUPER_bit: vm_call_flag_bits = 9;
pub const VM_CALL_OPT_SEND_bit: vm_call_flag_bits = 10;
pub const VM_CALL_KW_SPLAT_MUT_bit: vm_call_flag_bits = 11;
pub const VM_CALL_ARGS_SPLAT_MUT_bit: vm_call_flag_bits = 12;
pub const VM_CALL_FORWARDING_bit: vm_call_flag_bits = 13;
pub const VM_CALL__END: vm_call_flag_bits = 14;
pub type vm_call_flag_bits = u32;
#[repr(C)]
pub struct rb_callinfo_kwarg {
    pub keyword_len: ::std::os::raw::c_int,
    pub references: ::std::os::raw::c_int,
    pub keywords: __IncompleteArrayField<VALUE>,
}
#[repr(C)]
pub struct rb_callinfo {
    pub flags: VALUE,
    pub kwarg: *const rb_callinfo_kwarg,
    pub mid: VALUE,
    pub flag: VALUE,
    pub argc: VALUE,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rb_call_data {
    pub ci: *const rb_callinfo,
    pub cc: *const rb_callcache,
}
pub const RSTRING_CHILLED: ruby_rstring_private_flags = 49152;
pub type ruby_rstring_private_flags = u32;
pub const RHASH_PASS_AS_KEYWORDS: ruby_rhash_flags = 8192;
pub const RHASH_PROC_DEFAULT: ruby_rhash_flags = 16384;
pub const RHASH_ST_TABLE_FLAG: ruby_rhash_flags = 32768;
pub const RHASH_AR_TABLE_SIZE_MASK: ruby_rhash_flags = 983040;
pub const RHASH_AR_TABLE_SIZE_SHIFT: ruby_rhash_flags = 16;
pub const RHASH_AR_TABLE_BOUND_MASK: ruby_rhash_flags = 15728640;
pub const RHASH_AR_TABLE_BOUND_SHIFT: ruby_rhash_flags = 20;
pub const RHASH_LEV_SHIFT: ruby_rhash_flags = 25;
pub const RHASH_LEV_MAX: ruby_rhash_flags = 127;
pub type ruby_rhash_flags = u32;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rb_builtin_function {
    pub func_ptr: *const ::std::os::raw::c_void,
    pub argc: ::std::os::raw::c_int,
    pub index: ::std::os::raw::c_int,
    pub name: *const ::std::os::raw::c_char,
}
pub const YARVINSN_nop: ruby_vminsn_type = 0;
pub const YARVINSN_getlocal: ruby_vminsn_type = 1;
pub const YARVINSN_setlocal: ruby_vminsn_type = 2;
pub const YARVINSN_getblockparam: ruby_vminsn_type = 3;
pub const YARVINSN_setblockparam: ruby_vminsn_type = 4;
pub const YARVINSN_getblockparamproxy: ruby_vminsn_type = 5;
pub const YARVINSN_getspecial: ruby_vminsn_type = 6;
pub const YARVINSN_setspecial: ruby_vminsn_type = 7;
pub const YARVINSN_getinstancevariable: ruby_vminsn_type = 8;
pub const YARVINSN_setinstancevariable: ruby_vminsn_type = 9;
pub const YARVINSN_getclassvariable: ruby_vminsn_type = 10;
pub const YARVINSN_setclassvariable: ruby_vminsn_type = 11;
pub const YARVINSN_opt_getconstant_path: ruby_vminsn_type = 12;
pub const YARVINSN_getconstant: ruby_vminsn_type = 13;
pub const YARVINSN_setconstant: ruby_vminsn_type = 14;
pub const YARVINSN_getglobal: ruby_vminsn_type = 15;
pub const YARVINSN_setglobal: ruby_vminsn_type = 16;
pub const YARVINSN_putnil: ruby_vminsn_type = 17;
pub const YARVINSN_putself: ruby_vminsn_type = 18;
pub const YARVINSN_putobject: ruby_vminsn_type = 19;
pub const YARVINSN_putspecialobject: ruby_vminsn_type = 20;
pub const YARVINSN_putstring: ruby_vminsn_type = 21;
pub const YARVINSN_putchilledstring: ruby_vminsn_type = 22;
pub const YARVINSN_concatstrings: ruby_vminsn_type = 23;
pub const YARVINSN_anytostring: ruby_vminsn_type = 24;
pub const YARVINSN_toregexp: ruby_vminsn_type = 25;
pub const YARVINSN_intern: ruby_vminsn_type = 26;
pub const YARVINSN_newarray: ruby_vminsn_type = 27;
pub const YARVINSN_pushtoarraykwsplat: ruby_vminsn_type = 28;
pub const YARVINSN_duparray: ruby_vminsn_type = 29;
pub const YARVINSN_duphash: ruby_vminsn_type = 30;
pub const YARVINSN_expandarray: ruby_vminsn_type = 31;
pub const YARVINSN_concatarray: ruby_vminsn_type = 32;
pub const YARVINSN_concattoarray: ruby_vminsn_type = 33;
pub const YARVINSN_pushtoarray: ruby_vminsn_type = 34;
pub const YARVINSN_splatarray: ruby_vminsn_type = 35;
pub const YARVINSN_splatkw: ruby_vminsn_type = 36;
pub const YARVINSN_newhash: ruby_vminsn_type = 37;
pub const YARVINSN_newrange: ruby_vminsn_type = 38;
pub const YARVINSN_pop: ruby_vminsn_type = 39;
pub const YARVINSN_dup: ruby_vminsn_type = 40;
pub const YARVINSN_dupn: ruby_vminsn_type = 41;
pub const YARVINSN_swap: ruby_vminsn_type = 42;
pub const YARVINSN_opt_reverse: ruby_vminsn_type = 43;
pub const YARVINSN_topn: ruby_vminsn_type = 44;
pub const YARVINSN_setn: ruby_vminsn_type = 45;
pub const YARVINSN_adjuststack: ruby_vminsn_type = 46;
pub const YARVINSN_defined: ruby_vminsn_type = 47;
pub const YARVINSN_definedivar: ruby_vminsn_type = 48;
pub const YARVINSN_checkmatch: ruby_vminsn_type = 49;
pub const YARVINSN_checkkeyword: ruby_vminsn_type = 50;
pub const YARVINSN_checktype: ruby_vminsn_type = 51;
pub const YARVINSN_defineclass: ruby_vminsn_type = 52;
pub const YARVINSN_definemethod: ruby_vminsn_type = 53;
pub const YARVINSN_definesmethod: ruby_vminsn_type = 54;
pub const YARVINSN_send: ruby_vminsn_type = 55;
pub const YARVINSN_sendforward: ruby_vminsn_type = 56;
pub const YARVINSN_opt_send_without_block: ruby_vminsn_type = 57;
pub const YARVINSN_opt_new: ruby_vminsn_type = 58;
pub const YARVINSN_objtostring: ruby_vminsn_type = 59;
pub const YARVINSN_opt_ary_freeze: ruby_vminsn_type = 60;
pub const YARVINSN_opt_hash_freeze: ruby_vminsn_type = 61;
pub const YARVINSN_opt_str_freeze: ruby_vminsn_type = 62;
pub const YARVINSN_opt_nil_p: ruby_vminsn_type = 63;
pub const YARVINSN_opt_str_uminus: ruby_vminsn_type = 64;
pub const YARVINSN_opt_duparray_send: ruby_vminsn_type = 65;
pub const YARVINSN_opt_newarray_send: ruby_vminsn_type = 66;
pub const YARVINSN_invokesuper: ruby_vminsn_type = 67;
pub const YARVINSN_invokesuperforward: ruby_vminsn_type = 68;
pub const YARVINSN_invokeblock: ruby_vminsn_type = 69;
pub const YARVINSN_leave: ruby_vminsn_type = 70;
pub const YARVINSN_throw: ruby_vminsn_type = 71;
pub const YARVINSN_jump: ruby_vminsn_type = 72;
pub const YARVINSN_branchif: ruby_vminsn_type = 73;
pub const YARVINSN_branchunless: ruby_vminsn_type = 74;
pub const YARVINSN_branchnil: ruby_vminsn_type = 75;
pub const YARVINSN_once: ruby_vminsn_type = 76;
pub const YARVINSN_opt_case_dispatch: ruby_vminsn_type = 77;
pub const YARVINSN_opt_plus: ruby_vminsn_type = 78;
pub const YARVINSN_opt_minus: ruby_vminsn_type = 79;
pub const YARVINSN_opt_mult: ruby_vminsn_type = 80;
pub const YARVINSN_opt_div: ruby_vminsn_type = 81;
pub const YARVINSN_opt_mod: ruby_vminsn_type = 82;
pub const YARVINSN_opt_eq: ruby_vminsn_type = 83;
pub const YARVINSN_opt_neq: ruby_vminsn_type = 84;
pub const YARVINSN_opt_lt: ruby_vminsn_type = 85;
pub const YARVINSN_opt_le: ruby_vminsn_type = 86;
pub const YARVINSN_opt_gt: ruby_vminsn_type = 87;
pub const YARVINSN_opt_ge: ruby_vminsn_type = 88;
pub const YARVINSN_opt_ltlt: ruby_vminsn_type = 89;
pub const YARVINSN_opt_and: ruby_vminsn_type = 90;
pub const YARVINSN_opt_or: ruby_vminsn_type = 91;
pub const YARVINSN_opt_aref: ruby_vminsn_type = 92;
pub const YARVINSN_opt_aset: ruby_vminsn_type = 93;
pub const YARVINSN_opt_length: ruby_vminsn_type = 94;
pub const YARVINSN_opt_size: ruby_vminsn_type = 95;
pub const YARVINSN_opt_empty_p: ruby_vminsn_type = 96;
pub const YARVINSN_opt_succ: ruby_vminsn_type = 97;
pub const YARVINSN_opt_not: ruby_vminsn_type = 98;
pub const YARVINSN_opt_regexpmatch2: ruby_vminsn_type = 99;
pub const YARVINSN_invokebuiltin: ruby_vminsn_type = 100;
pub const YARVINSN_opt_invokebuiltin_delegate: ruby_vminsn_type = 101;
pub const YARVINSN_opt_invokebuiltin_delegate_leave: ruby_vminsn_type = 102;
pub const YARVINSN_getlocal_WC_0: ruby_vminsn_type = 103;
pub const YARVINSN_getlocal_WC_1: ruby_vminsn_type = 104;
pub const YARVINSN_setlocal_WC_0: ruby_vminsn_type = 105;
pub const YARVINSN_setlocal_WC_1: ruby_vminsn_type = 106;
pub const YARVINSN_putobject_INT2FIX_0_: ruby_vminsn_type = 107;
pub const YARVINSN_putobject_INT2FIX_1_: ruby_vminsn_type = 108;
pub const YARVINSN_trace_nop: ruby_vminsn_type = 109;
pub const YARVINSN_trace_getlocal: ruby_vminsn_type = 110;
pub const YARVINSN_trace_setlocal: ruby_vminsn_type = 111;
pub const YARVINSN_trace_getblockparam: ruby_vminsn_type = 112;
pub const YARVINSN_trace_setblockparam: ruby_vminsn_type = 113;
pub const YARVINSN_trace_getblockparamproxy: ruby_vminsn_type = 114;
pub const YARVINSN_trace_getspecial: ruby_vminsn_type = 115;
pub const YARVINSN_trace_setspecial: ruby_vminsn_type = 116;
pub const YARVINSN_trace_getinstancevariable: ruby_vminsn_type = 117;
pub const YARVINSN_trace_setinstancevariable: ruby_vminsn_type = 118;
pub const YARVINSN_trace_getclassvariable: ruby_vminsn_type = 119;
pub const YARVINSN_trace_setclassvariable: ruby_vminsn_type = 120;
pub const YARVINSN_trace_opt_getconstant_path: ruby_vminsn_type = 121;
pub const YARVINSN_trace_getconstant: ruby_vminsn_type = 122;
pub const YARVINSN_trace_setconstant: ruby_vminsn_type = 123;
pub const YARVINSN_trace_getglobal: ruby_vminsn_type = 124;
pub const YARVINSN_trace_setglobal: ruby_vminsn_type = 125;
pub const YARVINSN_trace_putnil: ruby_vminsn_type = 126;
pub const YARVINSN_trace_putself: ruby_vminsn_type = 127;
pub const YARVINSN_trace_putobject: ruby_vminsn_type = 128;
pub const YARVINSN_trace_putspecialobject: ruby_vminsn_type = 129;
pub const YARVINSN_trace_putstring: ruby_vminsn_type = 130;
pub const YARVINSN_trace_putchilledstring: ruby_vminsn_type = 131;
pub const YARVINSN_trace_concatstrings: ruby_vminsn_type = 132;
pub const YARVINSN_trace_anytostring: ruby_vminsn_type = 133;
pub const YARVINSN_trace_toregexp: ruby_vminsn_type = 134;
pub const YARVINSN_trace_intern: ruby_vminsn_type = 135;
pub const YARVINSN_trace_newarray: ruby_vminsn_type = 136;
pub const YARVINSN_trace_pushtoarraykwsplat: ruby_vminsn_type = 137;
pub const YARVINSN_trace_duparray: ruby_vminsn_type = 138;
pub const YARVINSN_trace_duphash: ruby_vminsn_type = 139;
pub const YARVINSN_trace_expandarray: ruby_vminsn_type = 140;
pub const YARVINSN_trace_concatarray: ruby_vminsn_type = 141;
pub const YARVINSN_trace_concattoarray: ruby_vminsn_type = 142;
pub const YARVINSN_trace_pushtoarray: ruby_vminsn_type = 143;
pub const YARVINSN_trace_splatarray: ruby_vminsn_type = 144;
pub const YARVINSN_trace_splatkw: ruby_vminsn_type = 145;
pub const YARVINSN_trace_newhash: ruby_vminsn_type = 146;
pub const YARVINSN_trace_newrange: ruby_vminsn_type = 147;
pub const YARVINSN_trace_pop: ruby_vminsn_type = 148;
pub const YARVINSN_trace_dup: ruby_vminsn_type = 149;
pub const YARVINSN_trace_dupn: ruby_vminsn_type = 150;
pub const YARVINSN_trace_swap: ruby_vminsn_type = 151;
pub const YARVINSN_trace_opt_reverse: ruby_vminsn_type = 152;
pub const YARVINSN_trace_topn: ruby_vminsn_type = 153;
pub const YARVINSN_trace_setn: ruby_vminsn_type = 154;
pub const YARVINSN_trace_adjuststack: ruby_vminsn_type = 155;
pub const YARVINSN_trace_defined: ruby_vminsn_type = 156;
pub const YARVINSN_trace_definedivar: ruby_vminsn_type = 157;
pub const YARVINSN_trace_checkmatch: ruby_vminsn_type = 158;
pub const YARVINSN_trace_checkkeyword: ruby_vminsn_type = 159;
pub const YARVINSN_trace_checktype: ruby_vminsn_type = 160;
pub const YARVINSN_trace_defineclass: ruby_vminsn_type = 161;
pub const YARVINSN_trace_definemethod: ruby_vminsn_type = 162;
pub const YARVINSN_trace_definesmethod: ruby_vminsn_type = 163;
pub const YARVINSN_trace_send: ruby_vminsn_type = 164;
pub const YARVINSN_trace_sendforward: ruby_vminsn_type = 165;
pub const YARVINSN_trace_opt_send_without_block: ruby_vminsn_type = 166;
pub const YARVINSN_trace_opt_new: ruby_vminsn_type = 167;
pub const YARVINSN_trace_objtostring: ruby_vminsn_type = 168;
pub const YARVINSN_trace_opt_ary_freeze: ruby_vminsn_type = 169;
pub const YARVINSN_trace_opt_hash_freeze: ruby_vminsn_type = 170;
pub const YARVINSN_trace_opt_str_freeze: ruby_vminsn_type = 171;
pub const YARVINSN_trace_opt_nil_p: ruby_vminsn_type = 172;
pub const YARVINSN_trace_opt_str_uminus: ruby_vminsn_type = 173;
pub const YARVINSN_trace_opt_duparray_send: ruby_vminsn_type = 174;
pub const YARVINSN_trace_opt_newarray_send: ruby_vminsn_type = 175;
pub const YARVINSN_trace_invokesuper: ruby_vminsn_type = 176;
pub const YARVINSN_trace_invokesuperforward: ruby_vminsn_type = 177;
pub const YARVINSN_trace_invokeblock: ruby_vminsn_type = 178;
pub const YARVINSN_trace_leave: ruby_vminsn_type = 179;
pub const YARVINSN_trace_throw: ruby_vminsn_type = 180;
pub const YARVINSN_trace_jump: ruby_vminsn_type = 181;
pub const YARVINSN_trace_branchif: ruby_vminsn_type = 182;
pub const YARVINSN_trace_branchunless: ruby_vminsn_type = 183;
pub const YARVINSN_trace_branchnil: ruby_vminsn_type = 184;
pub const YARVINSN_trace_once: ruby_vminsn_type = 185;
pub const YARVINSN_trace_opt_case_dispatch: ruby_vminsn_type = 186;
pub const YARVINSN_trace_opt_plus: ruby_vminsn_type = 187;
pub const YARVINSN_trace_opt_minus: ruby_vminsn_type = 188;
pub const YARVINSN_trace_opt_mult: ruby_vminsn_type = 189;
pub const YARVINSN_trace_opt_div: ruby_vminsn_type = 190;
pub const YARVINSN_trace_opt_mod: ruby_vminsn_type = 191;
pub const YARVINSN_trace_opt_eq: ruby_vminsn_type = 192;
pub const YARVINSN_trace_opt_neq: ruby_vminsn_type = 193;
pub const YARVINSN_trace_opt_lt: ruby_vminsn_type = 194;
pub const YARVINSN_trace_opt_le: ruby_vminsn_type = 195;
pub const YARVINSN_trace_opt_gt: ruby_vminsn_type = 196;
pub const YARVINSN_trace_opt_ge: ruby_vminsn_type = 197;
pub const YARVINSN_trace_opt_ltlt: ruby_vminsn_type = 198;
pub const YARVINSN_trace_opt_and: ruby_vminsn_type = 199;
pub const YARVINSN_trace_opt_or: ruby_vminsn_type = 200;
pub const YARVINSN_trace_opt_aref: ruby_vminsn_type = 201;
pub const YARVINSN_trace_opt_aset: ruby_vminsn_type = 202;
pub const YARVINSN_trace_opt_length: ruby_vminsn_type = 203;
pub const YARVINSN_trace_opt_size: ruby_vminsn_type = 204;
pub const YARVINSN_trace_opt_empty_p: ruby_vminsn_type = 205;
pub const YARVINSN_trace_opt_succ: ruby_vminsn_type = 206;
pub const YARVINSN_trace_opt_not: ruby_vminsn_type = 207;
pub const YARVINSN_trace_opt_regexpmatch2: ruby_vminsn_type = 208;
pub const YARVINSN_trace_invokebuiltin: ruby_vminsn_type = 209;
pub const YARVINSN_trace_opt_invokebuiltin_delegate: ruby_vminsn_type = 210;
pub const YARVINSN_trace_opt_invokebuiltin_delegate_leave: ruby_vminsn_type = 211;
pub const YARVINSN_trace_getlocal_WC_0: ruby_vminsn_type = 212;
pub const YARVINSN_trace_getlocal_WC_1: ruby_vminsn_type = 213;
pub const YARVINSN_trace_setlocal_WC_0: ruby_vminsn_type = 214;
pub const YARVINSN_trace_setlocal_WC_1: ruby_vminsn_type = 215;
pub const YARVINSN_trace_putobject_INT2FIX_0_: ruby_vminsn_type = 216;
pub const YARVINSN_trace_putobject_INT2FIX_1_: ruby_vminsn_type = 217;
pub const YARVINSN_zjit_getinstancevariable: ruby_vminsn_type = 218;
pub const YARVINSN_zjit_setinstancevariable: ruby_vminsn_type = 219;
pub const YARVINSN_zjit_definedivar: ruby_vminsn_type = 220;
pub const YARVINSN_zjit_send: ruby_vminsn_type = 221;
pub const YARVINSN_zjit_opt_send_without_block: ruby_vminsn_type = 222;
pub const YARVINSN_zjit_objtostring: ruby_vminsn_type = 223;
pub const YARVINSN_zjit_opt_nil_p: ruby_vminsn_type = 224;
pub const YARVINSN_zjit_invokeblock: ruby_vminsn_type = 225;
pub const YARVINSN_zjit_opt_plus: ruby_vminsn_type = 226;
pub const YARVINSN_zjit_opt_minus: ruby_vminsn_type = 227;
pub const YARVINSN_zjit_opt_mult: ruby_vminsn_type = 228;
pub const YARVINSN_zjit_opt_div: ruby_vminsn_type = 229;
pub const YARVINSN_zjit_opt_mod: ruby_vminsn_type = 230;
pub const YARVINSN_zjit_opt_eq: ruby_vminsn_type = 231;
pub const YARVINSN_zjit_opt_neq: ruby_vminsn_type = 232;
pub const YARVINSN_zjit_opt_lt: ruby_vminsn_type = 233;
pub const YARVINSN_zjit_opt_le: ruby_vminsn_type = 234;
pub const YARVINSN_zjit_opt_gt: ruby_vminsn_type = 235;
pub const YARVINSN_zjit_opt_ge: ruby_vminsn_type = 236;
pub const YARVINSN_zjit_opt_ltlt: ruby_vminsn_type = 237;
pub const YARVINSN_zjit_opt_and: ruby_vminsn_type = 238;
pub const YARVINSN_zjit_opt_or: ruby_vminsn_type = 239;
pub const YARVINSN_zjit_opt_aref: ruby_vminsn_type = 240;
pub const YARVINSN_zjit_opt_aset: ruby_vminsn_type = 241;
pub const YARVINSN_zjit_opt_length: ruby_vminsn_type = 242;
pub const YARVINSN_zjit_opt_size: ruby_vminsn_type = 243;
pub const YARVINSN_zjit_opt_empty_p: ruby_vminsn_type = 244;
pub const YARVINSN_zjit_opt_succ: ruby_vminsn_type = 245;
pub const YARVINSN_zjit_opt_not: ruby_vminsn_type = 246;
pub const YARVINSN_zjit_opt_regexpmatch2: ruby_vminsn_type = 247;
pub const VM_INSTRUCTION_SIZE: ruby_vminsn_type = 248;
pub type ruby_vminsn_type = u32;
pub type rb_iseq_callback = ::std::option::Option<
    unsafe extern "C" fn(arg1: *const rb_iseq_t, arg2: *mut ::std::os::raw::c_void),
>;
pub const DEFINED_NOT_DEFINED: defined_type = 0;
pub const DEFINED_NIL: defined_type = 1;
pub const DEFINED_IVAR: defined_type = 2;
pub const DEFINED_LVAR: defined_type = 3;
pub const DEFINED_GVAR: defined_type = 4;
pub const DEFINED_CVAR: defined_type = 5;
pub const DEFINED_CONST: defined_type = 6;
pub const DEFINED_METHOD: defined_type = 7;
pub const DEFINED_YIELD: defined_type = 8;
pub const DEFINED_ZSUPER: defined_type = 9;
pub const DEFINED_SELF: defined_type = 10;
pub const DEFINED_TRUE: defined_type = 11;
pub const DEFINED_FALSE: defined_type = 12;
pub const DEFINED_ASGN: defined_type = 13;
pub const DEFINED_EXPR: defined_type = 14;
pub const DEFINED_REF: defined_type = 15;
pub const DEFINED_FUNC: defined_type = 16;
pub const DEFINED_CONST_FROM: defined_type = 17;
pub type defined_type = u32;
pub type rb_seq_param_keyword_struct =
    rb_iseq_constant_body_rb_iseq_parameters_rb_iseq_param_keyword;
pub const ROBJECT_OFFSET_AS_HEAP_FIELDS: jit_bindgen_constants = 16;
pub const ROBJECT_OFFSET_AS_ARY: jit_bindgen_constants = 16;
pub const RUBY_OFFSET_RSTRING_LEN: jit_bindgen_constants = 16;
pub type jit_bindgen_constants = u32;
pub type rb_iseq_param_keyword_struct =
    rb_iseq_constant_body_rb_iseq_parameters_rb_iseq_param_keyword;
extern "C" {
    pub fn ruby_xfree(ptr: *mut ::std::os::raw::c_void);
    pub fn rb_class_attached_object(klass: VALUE) -> VALUE;
    pub fn rb_singleton_class(obj: VALUE) -> VALUE;
    pub fn rb_get_alloc_func(klass: VALUE) -> rb_alloc_func_t;
    pub fn rb_method_basic_definition_p(klass: VALUE, mid: ID) -> ::std::os::raw::c_int;
    pub fn rb_bug(fmt: *const ::std::os::raw::c_char, ...) -> !;
    pub fn rb_float_new(d: f64) -> VALUE;
    pub fn rb_gc_mark(obj: VALUE);
    pub fn rb_gc_mark_movable(obj: VALUE);
    pub fn rb_gc_location(obj: VALUE) -> VALUE;
    pub fn rb_gc_writebarrier(old: VALUE, young: VALUE);
    pub fn rb_class_get_superclass(klass: VALUE) -> VALUE;
    pub fn rb_funcall(recv: VALUE, mid: ID, n: ::std::os::raw::c_int, ...) -> VALUE;
    pub static mut rb_mKernel: VALUE;
    pub static mut rb_cBasicObject: VALUE;
    pub static mut rb_cArray: VALUE;
    pub static mut rb_cClass: VALUE;
    pub static mut rb_cFalseClass: VALUE;
    pub static mut rb_cFloat: VALUE;
    pub static mut rb_cHash: VALUE;
    pub static mut rb_cIO: VALUE;
    pub static mut rb_cInteger: VALUE;
    pub static mut rb_cModule: VALUE;
    pub static mut rb_cNilClass: VALUE;
    pub static mut rb_cNumeric: VALUE;
    pub static mut rb_cString: VALUE;
    pub static mut rb_cSymbol: VALUE;
    pub static mut rb_cThread: VALUE;
    pub static mut rb_cTrueClass: VALUE;
    pub fn rb_obj_class(obj: VALUE) -> VALUE;
    pub fn rb_ary_new_capa(capa: ::std::os::raw::c_long) -> VALUE;
    pub fn rb_ary_store(ary: VALUE, key: ::std::os::raw::c_long, val: VALUE);
    pub fn rb_ary_dup(ary: VALUE) -> VALUE;
    pub fn rb_ary_resurrect(ary: VALUE) -> VALUE;
    pub fn rb_ary_cat(ary: VALUE, train: *const VALUE, len: ::std::os::raw::c_long) -> VALUE;
    pub fn rb_ary_push(ary: VALUE, elem: VALUE) -> VALUE;
    pub fn rb_ary_clear(ary: VALUE) -> VALUE;
    pub fn rb_hash_new() -> VALUE;
    pub fn rb_hash_aref(hash: VALUE, key: VALUE) -> VALUE;
    pub fn rb_hash_aset(hash: VALUE, key: VALUE, val: VALUE) -> VALUE;
    pub fn rb_hash_bulk_insert(argc: ::std::os::raw::c_long, argv: *const VALUE, hash: VALUE);
    pub fn rb_obj_is_proc(recv: VALUE) -> VALUE;
    pub fn rb_sym2id(obj: VALUE) -> ID;
    pub fn rb_id2sym(id: ID) -> VALUE;
    pub fn rb_intern(name: *const ::std::os::raw::c_char) -> ID;
    pub fn rb_intern2(name: *const ::std::os::raw::c_char, len: ::std::os::raw::c_long) -> ID;
    pub fn rb_id2name(id: ID) -> *const ::std::os::raw::c_char;
    pub fn rb_class2name(klass: VALUE) -> *const ::std::os::raw::c_char;
    pub fn rb_class_new_instance_pass_kw(
        argc: ::std::os::raw::c_int,
        argv: *const VALUE,
        klass: VALUE,
    ) -> VALUE;
    pub fn rb_obj_is_kind_of(obj: VALUE, klass: VALUE) -> VALUE;
    pub fn rb_obj_alloc(klass: VALUE) -> VALUE;
    pub fn rb_obj_frozen_p(obj: VALUE) -> VALUE;
    pub fn rb_backref_get() -> VALUE;
    pub fn rb_range_new(beg: VALUE, end: VALUE, excl: ::std::os::raw::c_int) -> VALUE;
    pub fn rb_reg_nth_match(n: ::std::os::raw::c_int, md: VALUE) -> VALUE;
    pub fn rb_reg_last_match(md: VALUE) -> VALUE;
    pub fn rb_reg_match_pre(md: VALUE) -> VALUE;
    pub fn rb_reg_match_post(md: VALUE) -> VALUE;
    pub fn rb_reg_match_last(md: VALUE) -> VALUE;
    pub fn rb_utf8_str_new(
        ptr: *const ::std::os::raw::c_char,
        len: ::std::os::raw::c_long,
    ) -> VALUE;
    pub fn rb_str_buf_append(dst: VALUE, src: VALUE) -> VALUE;
    pub fn rb_str_dup(str_: VALUE) -> VALUE;
    pub fn rb_str_intern(str_: VALUE) -> VALUE;
    pub fn rb_mod_name(mod_: VALUE) -> VALUE;
    pub fn rb_ivar_get(obj: VALUE, name: ID) -> VALUE;
    pub fn rb_ivar_defined(obj: VALUE, name: ID) -> VALUE;
    pub fn rb_attr_get(obj: VALUE, name: ID) -> VALUE;
    pub fn rb_const_get(space: VALUE, name: ID) -> VALUE;
    pub fn rb_obj_info_dump(obj: VALUE);
    pub fn rb_class_allocate_instance(klass: VALUE) -> VALUE;
    pub fn rb_obj_equal(obj1: VALUE, obj2: VALUE) -> VALUE;
    pub fn rb_reg_new_ary(ary: VALUE, options: ::std::os::raw::c_int) -> VALUE;
    pub fn rb_ary_tmp_new_from_values(
        arg1: VALUE,
        arg2: ::std::os::raw::c_long,
        arg3: *const VALUE,
    ) -> VALUE;
    pub fn rb_ec_ary_new_from_values(
        ec: *mut rb_execution_context_struct,
        n: ::std::os::raw::c_long,
        elts: *const VALUE,
    ) -> VALUE;
    pub fn rb_vm_top_self() -> VALUE;
    pub static mut rb_vm_insn_count: u64;
    pub fn rb_method_entry_at(obj: VALUE, id: ID) -> *const rb_method_entry_t;
    pub fn rb_callable_method_entry(klass: VALUE, id: ID) -> *const rb_callable_method_entry_t;
    pub fn rb_callable_method_entry_or_negative(
        klass: VALUE,
        id: ID,
    ) -> *const rb_callable_method_entry_t;
    pub static mut rb_cRubyVM: VALUE;
    pub static mut rb_mRubyVMFrozenCore: VALUE;
    pub static mut rb_block_param_proxy: VALUE;
    pub fn rb_vm_ep_local_ep(ep: *const VALUE) -> *const VALUE;
    pub fn rb_iseq_path(iseq: *const rb_iseq_t) -> VALUE;
    pub fn rb_vm_env_write(ep: *const VALUE, index: ::std::os::raw::c_int, v: VALUE);
    pub fn rb_vm_bh_to_procval(ec: *const rb_execution_context_t, block_handler: VALUE) -> VALUE;
    pub fn rb_vm_frame_method_entry(
        cfp: *const rb_control_frame_t,
    ) -> *const rb_callable_method_entry_t;
    pub fn rb_obj_info(obj: VALUE) -> *const ::std::os::raw::c_char;
    pub fn rb_ec_stack_check(ec: *mut rb_execution_context_struct) -> ::std::os::raw::c_int;
    pub fn rb_shape_id_offset() -> i32;
    pub fn rb_obj_shape_id(obj: VALUE) -> shape_id_t;
    pub fn rb_shape_get_iv_index(shape_id: shape_id_t, id: ID, value: *mut attr_index_t) -> bool;
    pub fn rb_shape_transition_add_ivar_no_warnings(
        klass: VALUE,
        original_shape_id: shape_id_t,
        id: ID,
    ) -> shape_id_t;
    pub fn rb_ivar_get_at(obj: VALUE, index: attr_index_t, id: ID) -> VALUE;
    pub fn rb_ivar_get_at_no_ractor_check(obj: VALUE, index: attr_index_t) -> VALUE;
    pub fn rb_gvar_get(arg1: ID) -> VALUE;
    pub fn rb_gvar_set(arg1: ID, arg2: VALUE) -> VALUE;
    pub fn rb_ensure_iv_list_size(obj: VALUE, current_len: u32, newsize: u32);
    pub fn rb_vm_barrier();
    pub fn rb_str_byte_substr(str_: VALUE, beg: VALUE, len: VALUE) -> VALUE;
    pub fn rb_str_substr_two_fixnums(
        str_: VALUE,
        beg: VALUE,
        len: VALUE,
        empty: ::std::os::raw::c_int,
    ) -> VALUE;
    pub fn rb_obj_as_string_result(str_: VALUE, obj: VALUE) -> VALUE;
    pub fn rb_str_concat_literals(num: usize, strary: *const VALUE) -> VALUE;
    pub fn rb_ec_str_resurrect(
        ec: *mut rb_execution_context_struct,
        str_: VALUE,
        chilled: bool,
    ) -> VALUE;
    pub fn rb_to_hash_type(obj: VALUE) -> VALUE;
    pub fn rb_hash_stlike_foreach(
        hash: VALUE,
        func: st_foreach_callback_func,
        arg: st_data_t,
    ) -> ::std::os::raw::c_int;
    pub fn rb_hash_new_with_size(size: st_index_t) -> VALUE;
    pub fn rb_hash_resurrect(hash: VALUE) -> VALUE;
    pub fn rb_hash_stlike_lookup(
        hash: VALUE,
        key: st_data_t,
        pval: *mut st_data_t,
    ) -> ::std::os::raw::c_int;
    pub fn rb_insn_len(insn: VALUE) -> ::std::os::raw::c_int;
    pub fn rb_vm_insn_decode(encoded: VALUE) -> ::std::os::raw::c_int;
    pub fn rb_float_plus(x: VALUE, y: VALUE) -> VALUE;
    pub fn rb_float_minus(x: VALUE, y: VALUE) -> VALUE;
    pub fn rb_float_mul(x: VALUE, y: VALUE) -> VALUE;
    pub fn rb_float_div(x: VALUE, y: VALUE) -> VALUE;
    pub fn rb_fix_aref(fix: VALUE, idx: VALUE) -> VALUE;
    pub fn rb_vm_insn_addr2opcode(addr: *const ::std::os::raw::c_void) -> ::std::os::raw::c_int;
    pub fn rb_iseq_line_no(iseq: *const rb_iseq_t, pos: usize) -> ::std::os::raw::c_uint;
    pub fn rb_iseqw_to_iseq(iseqw: VALUE) -> *const rb_iseq_t;
    pub fn rb_iseq_label(iseq: *const rb_iseq_t) -> VALUE;
    pub fn rb_profile_frames(
        start: ::std::os::raw::c_int,
        limit: ::std::os::raw::c_int,
        buff: *mut VALUE,
        lines: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
    pub fn rb_jit_cont_each_iseq(callback: rb_iseq_callback, data: *mut ::std::os::raw::c_void);
    pub fn rb_yjit_exit_locations_dict(
        yjit_raw_samples: *mut VALUE,
        yjit_line_samples: *mut ::std::os::raw::c_int,
        samples_len: ::std::os::raw::c_int,
    ) -> VALUE;
    pub fn rb_c_method_tracing_currently_enabled(ec: *const rb_execution_context_t) -> bool;
    pub fn rb_full_cfunc_return(ec: *mut rb_execution_context_t, return_value: VALUE);
    pub fn rb_iseq_get_yjit_payload(iseq: *const rb_iseq_t) -> *mut ::std::os::raw::c_void;
    pub fn rb_iseq_set_yjit_payload(iseq: *const rb_iseq_t, payload: *mut ::std::os::raw::c_void);
    pub fn rb_get_symbol_id(namep: VALUE) -> ID;
    pub fn rb_optimized_call(
        recv: *mut VALUE,
        ec: *mut rb_execution_context_t,
        argc: ::std::os::raw::c_int,
        argv: *mut VALUE,
        kw_splat: ::std::os::raw::c_int,
        block_handler: VALUE,
    ) -> VALUE;
    pub fn rb_yjit_builtin_function(iseq: *const rb_iseq_t) -> *const rb_builtin_function;
    pub fn rb_yjit_str_simple_append(str1: VALUE, str2: VALUE) -> VALUE;
    pub fn rb_vm_base_ptr(cfp: *mut rb_control_frame_struct) -> *mut VALUE;
    pub fn rb_str_neq_internal(str1: VALUE, str2: VALUE) -> VALUE;
    pub fn rb_ary_unshift_m(argc: ::std::os::raw::c_int, argv: *mut VALUE, ary: VALUE) -> VALUE;
    pub fn rb_yjit_rb_ary_subseq_length(ary: VALUE, beg: ::std::os::raw::c_long) -> VALUE;
    pub fn rb_yjit_ruby2_keywords_splat_p(obj: VALUE) -> usize;
    pub fn rb_yjit_splat_varg_checks(
        sp: *mut VALUE,
        splat_array: VALUE,
        cfp: *mut rb_control_frame_t,
    ) -> VALUE;
    pub fn rb_yjit_splat_varg_cfunc(stack_splat_array: *mut VALUE) -> ::std::os::raw::c_int;
    pub fn rb_yjit_dump_iseq_loc(iseq: *const rb_iseq_t, insn_idx: u32);
    pub fn rb_yjit_iseq_inspect(iseq: *const rb_iseq_t) -> *mut ::std::os::raw::c_char;
    pub fn rb_RSTRUCT_SET(st: VALUE, k: ::std::os::raw::c_int, v: VALUE);
    pub fn rb_ENCODING_GET(obj: VALUE) -> ::std::os::raw::c_int;
    pub fn rb_yjit_constcache_shareable(ice: *const iseq_inline_constant_cache_entry) -> bool;
    pub fn rb_yjit_obj_written(
        old: VALUE,
        young: VALUE,
        file: *const ::std::os::raw::c_char,
        line: ::std::os::raw::c_int,
    );
    pub fn rb_object_shape_count() -> VALUE;
    pub fn rb_yjit_shape_obj_too_complex_p(obj: VALUE) -> bool;
    pub fn rb_yjit_shape_capacity(shape_id: shape_id_t) -> attr_index_t;
    pub fn rb_yjit_shape_index(shape_id: shape_id_t) -> attr_index_t;
    pub fn rb_yjit_sendish_sp_pops(ci: *const rb_callinfo) -> usize;
    pub fn rb_yjit_invokeblock_sp_pops(ci: *const rb_callinfo) -> usize;
    pub fn rb_yjit_set_exception_return(
        cfp: *mut rb_control_frame_t,
        leave_exit: *mut ::std::os::raw::c_void,
        leave_exception: *mut ::std::os::raw::c_void,
    );
    pub fn rb_vm_instruction_size() -> u32;
    pub fn rb_iseq_encoded_size(iseq: *const rb_iseq_t) -> ::std::os::raw::c_uint;
    pub fn rb_iseq_pc_at_idx(iseq: *const rb_iseq_t, insn_idx: u32) -> *mut VALUE;
    pub fn rb_iseq_opcode_at_pc(iseq: *const rb_iseq_t, pc: *const VALUE) -> ::std::os::raw::c_int;
    pub fn rb_RSTRING_LEN(str_: VALUE) -> ::std::os::raw::c_ulong;
    pub fn rb_RSTRING_PTR(str_: VALUE) -> *mut ::std::os::raw::c_char;
    pub fn rb_insn_name(insn: VALUE) -> *const ::std::os::raw::c_char;
    pub fn rb_vm_ci_argc(ci: *const rb_callinfo) -> ::std::os::raw::c_uint;
    pub fn rb_vm_ci_mid(ci: *const rb_callinfo) -> ID;
    pub fn rb_vm_ci_flag(ci: *const rb_callinfo) -> ::std::os::raw::c_uint;
    pub fn rb_vm_ci_kwarg(ci: *const rb_callinfo) -> *const rb_callinfo_kwarg;
    pub fn rb_get_cikw_keyword_len(cikw: *const rb_callinfo_kwarg) -> ::std::os::raw::c_int;
    pub fn rb_get_cikw_keywords_idx(
        cikw: *const rb_callinfo_kwarg,
        idx: ::std::os::raw::c_int,
    ) -> VALUE;
    pub fn rb_METHOD_ENTRY_VISI(me: *const rb_callable_method_entry_t) -> rb_method_visibility_t;
    pub fn rb_get_cme_def_type(cme: *const rb_callable_method_entry_t) -> rb_method_type_t;
    pub fn rb_get_cme_def_body_attr_id(cme: *const rb_callable_method_entry_t) -> ID;
    pub fn rb_get_cme_def_body_optimized_type(
        cme: *const rb_callable_method_entry_t,
    ) -> method_optimized_type;
    pub fn rb_get_cme_def_body_optimized_index(
        cme: *const rb_callable_method_entry_t,
    ) -> ::std::os::raw::c_uint;
    pub fn rb_get_cme_def_body_cfunc(
        cme: *const rb_callable_method_entry_t,
    ) -> *mut rb_method_cfunc_t;
    pub fn rb_get_def_method_serial(def: *const rb_method_definition_t) -> usize;
    pub fn rb_get_def_original_id(def: *const rb_method_definition_t) -> ID;
    pub fn rb_get_def_bmethod_proc(def: *mut rb_method_definition_t) -> VALUE;
    pub fn rb_jit_get_proc_ptr(procv: VALUE) -> *mut rb_proc_t;
    pub fn rb_jit_iseq_builtin_attrs(iseq: *const rb_iseq_t) -> ::std::os::raw::c_uint;
    pub fn rb_get_mct_argc(mct: *const rb_method_cfunc_t) -> ::std::os::raw::c_int;
    pub fn rb_get_mct_func(mct: *const rb_method_cfunc_t) -> *mut ::std::os::raw::c_void;
    pub fn rb_get_def_iseq_ptr(def: *mut rb_method_definition_t) -> *const rb_iseq_t;
    pub fn rb_get_iseq_body_local_iseq(iseq: *const rb_iseq_t) -> *const rb_iseq_t;
    pub fn rb_get_iseq_body_parent_iseq(iseq: *const rb_iseq_t) -> *const rb_iseq_t;
    pub fn rb_get_iseq_body_local_table_size(iseq: *const rb_iseq_t) -> ::std::os::raw::c_uint;
    pub fn rb_get_iseq_body_iseq_encoded(iseq: *const rb_iseq_t) -> *mut VALUE;
    pub fn rb_get_iseq_body_stack_max(iseq: *const rb_iseq_t) -> ::std::os::raw::c_uint;
    pub fn rb_get_iseq_body_type(iseq: *const rb_iseq_t) -> rb_iseq_type;
    pub fn rb_get_iseq_flags_has_lead(iseq: *const rb_iseq_t) -> bool;
    pub fn rb_get_iseq_flags_has_opt(iseq: *const rb_iseq_t) -> bool;
    pub fn rb_get_iseq_flags_has_kw(iseq: *const rb_iseq_t) -> bool;
    pub fn rb_get_iseq_flags_has_post(iseq: *const rb_iseq_t) -> bool;
    pub fn rb_get_iseq_flags_has_kwrest(iseq: *const rb_iseq_t) -> bool;
    pub fn rb_get_iseq_flags_anon_kwrest(iseq: *const rb_iseq_t) -> bool;
    pub fn rb_get_iseq_flags_has_rest(iseq: *const rb_iseq_t) -> bool;
    pub fn rb_get_iseq_flags_ruby2_keywords(iseq: *const rb_iseq_t) -> bool;
    pub fn rb_get_iseq_flags_has_block(iseq: *const rb_iseq_t) -> bool;
    pub fn rb_get_iseq_flags_ambiguous_param0(iseq: *const rb_iseq_t) -> bool;
    pub fn rb_get_iseq_flags_accepts_no_kwarg(iseq: *const rb_iseq_t) -> bool;
    pub fn rb_get_iseq_flags_forwardable(iseq: *const rb_iseq_t) -> bool;
    pub fn rb_get_iseq_body_param_keyword(
        iseq: *const rb_iseq_t,
    ) -> *const rb_iseq_param_keyword_struct;
    pub fn rb_get_iseq_body_param_size(iseq: *const rb_iseq_t) -> ::std::os::raw::c_uint;
    pub fn rb_get_iseq_body_param_lead_num(iseq: *const rb_iseq_t) -> ::std::os::raw::c_int;
    pub fn rb_get_iseq_body_param_opt_num(iseq: *const rb_iseq_t) -> ::std::os::raw::c_int;
    pub fn rb_get_iseq_body_param_opt_table(iseq: *const rb_iseq_t) -> *const VALUE;
    pub fn rb_get_ec_cfp(ec: *const rb_execution_context_t) -> *mut rb_control_frame_struct;
    pub fn rb_get_cfp_iseq(cfp: *mut rb_control_frame_struct) -> *const rb_iseq_t;
    pub fn rb_get_cfp_pc(cfp: *mut rb_control_frame_struct) -> *mut VALUE;
    pub fn rb_get_cfp_sp(cfp: *mut rb_control_frame_struct) -> *mut VALUE;
    pub fn rb_get_cfp_self(cfp: *mut rb_control_frame_struct) -> VALUE;
    pub fn rb_get_cfp_ep(cfp: *mut rb_control_frame_struct) -> *mut VALUE;
    pub fn rb_get_cfp_ep_level(cfp: *mut rb_control_frame_struct, lv: u32) -> *const VALUE;
    pub fn rb_yarv_class_of(obj: VALUE) -> VALUE;
    pub fn rb_FL_TEST(obj: VALUE, flags: VALUE) -> VALUE;
    pub fn rb_FL_TEST_RAW(obj: VALUE, flags: VALUE) -> VALUE;
    pub fn rb_RB_TYPE_P(obj: VALUE, t: ruby_value_type) -> bool;
    pub fn rb_RSTRUCT_LEN(st: VALUE) -> ::std::os::raw::c_long;
    pub fn rb_get_call_data_ci(cd: *const rb_call_data) -> *const rb_callinfo;
    pub fn rb_BASIC_OP_UNREDEFINED_P(bop: ruby_basic_operators, klass: u32) -> bool;
    pub fn rb_RCLASS_ORIGIN(c: VALUE) -> VALUE;
    pub fn rb_assert_iseq_handle(handle: VALUE);
    pub fn rb_assert_holding_vm_lock();
    pub fn rb_IMEMO_TYPE_P(imemo: VALUE, imemo_type: imemo_type) -> ::std::os::raw::c_int;
    pub fn rb_assert_cme_handle(handle: VALUE);
    pub fn rb_yarv_ary_entry_internal(ary: VALUE, offset: ::std::os::raw::c_long) -> VALUE;
    pub fn rb_jit_array_len(a: VALUE) -> ::std::os::raw::c_long;
    pub fn rb_set_cfp_pc(cfp: *mut rb_control_frame_struct, pc: *const VALUE);
    pub fn rb_set_cfp_sp(cfp: *mut rb_control_frame_struct, sp: *mut VALUE);
    pub fn rb_jit_shape_too_complex_p(shape_id: shape_id_t) -> bool;
    pub fn rb_jit_multi_ractor_p() -> bool;
    pub fn rb_jit_vm_lock_then_barrier(
        recursive_lock_level: *mut ::std::os::raw::c_uint,
        file: *const ::std::os::raw::c_char,
        line: ::std::os::raw::c_int,
    );
    pub fn rb_jit_vm_unlock(
        recursive_lock_level: *mut ::std::os::raw::c_uint,
        file: *const ::std::os::raw::c_char,
        line: ::std::os::raw::c_int,
    );
    pub fn rb_iseq_reset_jit_func(iseq: *const rb_iseq_t);
    pub fn rb_jit_get_page_size() -> u32;
    pub fn rb_jit_reserve_addr_space(mem_size: u32) -> *mut u8;
    pub fn rb_jit_for_each_iseq(callback: rb_iseq_callback, data: *mut ::std::os::raw::c_void);
    pub fn rb_jit_mark_writable(mem_block: *mut ::std::os::raw::c_void, mem_size: u32) -> bool;
    pub fn rb_jit_mark_executable(mem_block: *mut ::std::os::raw::c_void, mem_size: u32);
    pub fn rb_jit_mark_unused(mem_block: *mut ::std::os::raw::c_void, mem_size: u32) -> bool;
    pub fn rb_jit_icache_invalidate(
        start: *mut ::std::os::raw::c_void,
        end: *mut ::std::os::raw::c_void,
    );
    pub fn rb_jit_fix_mod_fix(recv: VALUE, obj: VALUE) -> VALUE;
    pub fn rb_jit_fix_div_fix(recv: VALUE, obj: VALUE) -> VALUE;
    pub fn rb_yarv_str_eql_internal(str1: VALUE, str2: VALUE) -> VALUE;
    pub fn rb_jit_str_concat_codepoint(str_: VALUE, codepoint: VALUE);
}
